package messenger;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import javax.swing.JTextArea;

/**
 * Receiver's class.
 * This thread receives all messages from multicast clients,
 * and prints it on the GUI receiver's board.
 * 
 * @author Carlos Pires (CarloStuius)
 *
 */
public class DateClient extends Thread {
	
	private MulticastSocket socket;//multicast socket
	private InetAddress address;//multicast address
	private JTextArea text_area;//"pointer" to receiver's board
	
	/**
	 * Thread's hearth. 
	 */
	public void run()
	{
		String received = null;
		DatagramPacket packet;
		while (true)
		{
		     byte []sbuf = new byte[200];
		     packet = new DatagramPacket(sbuf, sbuf.length);
		     try {
				socket.receive(packet);
			} catch (IOException e) {
				e.printStackTrace();
			}
			// display response
			received = new String(packet.getData());
			received = received.trim();
			text_area.setText(text_area.getText()+"\n"+received);
		}
	}
	
	/**
	 * Destructor.
	 */
	public void finalize() throws IOException
	{
		socket.leaveGroup(address);
		socket.close();
	}
	
	/**
	 * Constructor.
	 * 
	 * @param multicast_addr
	 * @param port
	 * @param recepcao
	 * @throws IOException
	 * @throws InterruptedException
	 */
	public DateClient(String multicast_addr, int port, JTextArea recepcao) throws IOException, InterruptedException 
	{
		socket = new MulticastSocket(port);
		address = InetAddress.getByName(multicast_addr);
		socket.joinGroup(address);
		socket.setLoopbackMode(false);
		
		text_area = recepcao;
	}

}
