package messenger;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;


/**
 * Sender's class.
 * This class, collects the sender message, and sends it to multicast
 * clients.
 * 
 * @author Carlos Pires (carloStudius)
 *
 */
public class DateServer extends Thread {
	
	private DatagramSocket socket;
	private DatagramPacket packet;
	private InetAddress address;
	private final int multicast_port;
	
	/**
	 * Constructor.
	 * 
	 * @param multicast_addr
	 * @param multicast_port_
	 * @throws Exception
	 */
	public DateServer(String multicast_addr, int multicast_port_) throws Exception
	{
		address = InetAddress.getByName(multicast_addr);
		socket = new DatagramSocket();
		multicast_port = multicast_port_;
	}
	
	/**
	 * Destructor.
	 * 
	 */
	public void finalize() throws IOException
	{
		socket.close();
	}
	
	/**
	 * Get info (bytes) from sender's message (String).
	 * 
	 * @param texto
	 * @return
	 * @throws Exception
	 */
	private byte[] trata(String texto) throws Exception
	{
		return texto.getBytes();
	}
	
	public void run()
	{
		
	}
	
	public void send(String texto)
	{
		byte[] resposta = null;
		
		try {
			resposta = trata(texto);
		} catch (Exception e) {
			e.printStackTrace();
		}
	    packet = new DatagramPacket(resposta, resposta.length,address,multicast_port);
	    try {
			socket.send(packet);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
