package messenger;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;


/**
 * 
 * Messenger main class.
 * MulticastMessenger is a multithreading mini-application that simply makes
 * possible to comunicate with other people through IP multicast tecnology. 
 *
 * @author Carlos Galinho (CarloStudius)
 */
public class Messenger extends JFrame {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private DateServer a;//sender
	private DateClient b;//receiver
	private JTextField nickname;//nickname field
	private Integer porta = 8001;//port number field
	private String ip = "230.1.1.2";//ip field
	JTextArea recepcao;//receiver's messages board
	
	
	/**
	 * Insert first line (3 fields) into program window
	 * 
	 * @param contentor
	 */
	public void insert_first_line(Container contentor)
	{
		nickname = new JTextField();
		nickname.setText("Annimo");
		final JTextField ip_ = new JTextField();
		ip_.setText(ip);
		final JTextField porta_ = new JTextField();
		porta_.setText(porta.toString());
		
		contentor.add(new JLabel("Nickname"));
		contentor.add(nickname);
		contentor.add(new JLabel("Endereo IP multicast"));
		contentor.add(ip_);
		contentor.add(new JLabel("Porta multicast"));
		contentor.add(porta_);
		
		ip_.addActionListener(new ActionListener() {
			/**
			 * Destroy child-threads, and start new ones.
			 */
			public void actionPerformed(ActionEvent e) {
				ip = ip_.getText();
				try {
					a = new DateServer(ip,porta);
					a.start();
					b = new DateClient(ip,porta,recepcao);
					b.start();
				} catch (Exception e1) {
					e1.printStackTrace();
				}
				recepcao.setText(recepcao.getText()+"\nIP do grupo multicast alterada!");
			}
		});
		porta_.addActionListener(new ActionListener() {
			/**
			 * Destroy child-threads, and start new ones.
			 */
			public void actionPerformed(ActionEvent e) {
				porta = Integer.parseInt(porta_.getText());
				try {
					a = new DateServer(ip,porta);
					a.start();
					b = new DateClient(ip,porta,recepcao);
					b.start();
				} catch (Exception e1) {
					e1.printStackTrace();
				}
				recepcao.setText(recepcao.getText()+"\nPorta do grupo multicast alterada!");
			}
		});
	}
	
	/**
	 * Messenger constructor. 
	 * Build GUI application and start main program.
	 * 
	 * @param nome
	 * @throws NumberFormatException
	 * @throws Exception
	 */
	public Messenger(String nome) throws NumberFormatException, Exception
	{
		this.setTitle(nome);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		this.getContentPane().setLayout(new BorderLayout());
		
		// receiver's message board
		recepcao = new JTextArea();
		recepcao.setEditable(false);
		final JScrollPane recepcao_scroll = new JScrollPane(recepcao);
		
		Container contentor = new JPanel(new GridLayout(1,6));
		insert_first_line(contentor);
		
		//starts child-threads
		a = new DateServer(ip,porta);
		a.start();
		b = new DateClient(ip,porta,recepcao);
		b.start();
		
		final JTextField envio = new JTextField();
		envio.addActionListener(new ActionListener() {
			/**
			 * Send message to multicast clients and clean sender's board.
			 */
			public void actionPerformed(ActionEvent e) {
				a.send(nickname.getText()+": "+envio.getText());
				envio.setText("");
				recepcao_scroll.getVerticalScrollBar().setValue(recepcao_scroll.getVerticalScrollBar().getMaximum());
			}
			
		});
		
		//builds GUI content
		this.getContentPane().add(contentor,BorderLayout.NORTH);
		this.getContentPane().add(recepcao_scroll,BorderLayout.CENTER);
		this.getContentPane().add(envio,BorderLayout.SOUTH);
		
		this.setSize(380, 400);
		this.setVisible(true);
	}

    /** 
     * Call the program.
     * 
     * @throws Exception 
     */
    public static void main(String[] args) throws Exception {
    	new Messenger("MultiCastMessenger");
    }
} 