/*
 * Decompiled with CFR 0.152.
 */
package healthCare;

import healthCare.TextDB;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StreamTokenizer;

public class Bypass {
    private StreamTokenizer stok;
    private Reader reader;
    private FileReader file;
    private String nome_ficheiro;
    private boolean alarme_int_grande;
    private boolean alarme_int_pequeno;
    private boolean alarme_int_medio;
    private TextDB.Languages language = TextDB.Languages.PT;

    protected boolean getAlarmeG() {
        return this.alarme_int_grande;
    }

    protected void setAlarmeG(boolean a) throws Exception {
        this.alarme_int_grande = a;
        this.salva_dados();
    }

    protected boolean getAlarmeP() {
        return this.alarme_int_pequeno;
    }

    protected void setAlarmeP(boolean a) throws Exception {
        this.alarme_int_pequeno = a;
        this.salva_dados();
    }

    protected boolean getAlarmeM() {
        return this.alarme_int_medio;
    }

    protected void setAlarmeM(boolean a) throws Exception {
        this.alarme_int_medio = a;
        this.salva_dados();
    }

    protected Bypass(String file_name) throws IOException {
        this.nome_ficheiro = file_name;
        this.file = new FileReader(file_name);
        this.reader = new BufferedReader(this.file);
        this.carrega_dados();
    }

    protected void finalize() throws IOException {
        this.file.close();
        this.reader.close();
    }

    protected void iniciaToken() throws IOException {
        this.stok = new StreamTokenizer(this.reader);
        this.stok.parseNumbers();
        this.stok.nextToken();
    }

    private void carrega_dados() throws IOException {
        this.iniciaToken();
        this.alarme_int_grande = this.stok.sval.equals("true");
        this.stok.nextToken();
        this.alarme_int_medio = this.stok.sval.equals("true");
        this.stok.nextToken();
        this.alarme_int_pequeno = this.stok.sval.equals("true");
        this.stok.nextToken();
        this.language = this.getLanguage(this.stok.sval);
        this.stok.nextToken();
        this.file.close();
        this.reader.close();
    }

    private TextDB.Languages getLanguage(String sval) {
        if (sval.equals("PT")) {
            return TextDB.Languages.PT;
        }
        if (sval.equals("EN")) {
            return TextDB.Languages.EN;
        }
        return TextDB.Languages.PT;
    }

    private void salva_dados() throws Exception {
        FileOutputStream file;
        try {
            file = new FileOutputStream(this.nome_ficheiro);
        }
        catch (FileNotFoundException e) {
            throw new Exception("Erro ao criar ficheiro!");
        }
        PrintStream ficheiro = new PrintStream(file);
        ficheiro.print(this.alarme_int_grande);
        ficheiro.print(" ");
        ficheiro.print(this.alarme_int_medio);
        ficheiro.print(" ");
        ficheiro.print(this.alarme_int_pequeno);
        ficheiro.print(" ");
        ficheiro.print((Object)this.language);
        ficheiro.print(" ");
        file.close();
        ficheiro.close();
    }

    public int getLanguageCode() {
        return this.language.ordinal();
    }

    public void setLanguage(TextDB.Languages lang) throws Exception {
        this.language = lang;
        this.salva_dados();
    }

    public TextDB.Languages getLanguage() {
        return this.language;
    }
}

